%%
clear all

k=0.8;   %points per nm
SaveToFile=true; myPath='E:\AMATLAB\reticle\';MyFile='';
UseNewInLine=true;
Plot4Electrodes=false;


aa=1;
    InLineWidth=20;  %20;
    InLineGapWidth=50;%  25;
disp('started')

MakeSingleObjectInLine=false;
UnionMultiObjects=false;  % need for eectrodes

%%
% Fukushima back electrode%
%{
%x=[    ]*1000;
%x=[-75 150; -2 6;-2 -10; 2 -10; 2 6; 75 150;75 300; -75 300;  ]*1000;
%x=[65 280; -65 280 ; -55 250; 55 250]; 
% anti clockwise
%}


%
% square

%{
    XWidth=10E3; % nm   x width
    YWidth=20E3; %nm  y width 
MyObject=[XWidth/2 YWidth/2;-XWidth/2 YWidth/2;-XWidth/2 -YWidth/2;XWidth/2 -YWidth/2];
MakeSingleObjectInLine=true;UnionMultiObjects=false;
Plot4Electrodes=false;
UnionMultiObjects=false; 
UseNewInLine=false;
MakeSingleObjectInLine=true;
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% cross 
%{
CrossWidth=10E3; %nm
CrossLength=80E3; %nm
L=CrossLength/2; dL=CrossWidth/2;
MyObject=[-L -dL; -dL -dL; -dL -L; dL -L; dL -dL; L -dL; L dL; dL dL; dL L; -dL L; -dL dL; -L dL];
Plot4Electrodes=false;
UnionMultiObjects=false; 
UseNewInLine=false;
MakeSingleObjectInLine=true;
%}

%%%%%%%%%%%%
%orthogone
    XWidth=0.5*80E3; % nm   x width
    
    
  YWidth= XWidth; 
MyObject=[XWidth/2 YWidth;  -XWidth/2 YWidth;   -XWidth YWidth/2;   -XWidth -YWidth/2;  -XWidth/2 -YWidth; XWidth/2 -YWidth; XWidth -YWidth/2; XWidth YWidth/2;];
MakeSingleObjectInLine=true;UnionMultiObjects=false;
Plot4Electrodes=false;
UnionMultiObjects=false; 
UseNewInLine=true;
MakeSingleObjectInLine=true;

%%%%%%%%%%%%%%%%%%%%%%%%%%
%multiobject joint
% top electrodes for Hall 
%{
j=0;UnionMultiObjects=true;
Plot4Electrodes=false;
%%%%%% gmr 
%gmr 'VZ_HallY30x2'  HallY30x2Con
%{

j=j+1;mySq{j}=MySquare(1.2E3,13E3, [0E3 17E3],'c','t'); % to y hall contact  
j=j+1;mySq{j}=MySquare(21.8E3,[4000 2000], [0.7E3 17.5E3],'r','c');  % to y hall long
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

j=j+1;mySq{j}=MySquare(19.5E3,[5e3 1.2E3], [-3.5E3 0],'r','c');  % to x Hall left side
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
%
j=j+1;mySq{j}=MySquare(1.2E3,13E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(21.8E3,[2000 4000], [-0.7E3 -17.5E3],'l','c');
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');

j=j+1;mySq{j}=MySquare(23E3,[0.8E3 2E3], [-0.4 -1E3],'l','c');      % to x Hall right side
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [23E3 -0.8E3],'r','b');
%}

%gmr 1 'HallY400x30umElH
%{

j=j+1;mySq{j}=MySquare(1.2E3,15E3, [0E3 17E3],'c','t'); % to y hall contact  low part
j=j+1;mySq{j}=MySquare(22.8E3,[4000 2000], [0.7E3 17.5E3],'r','c');  % to y hall long
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

j=j+1;mySq{j}=MySquare(19.5E3,[5e3 1.2E3], [-3.5E3 0],'r','c');  % to x Hall left side
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
%
j=j+1;mySq{j}=MySquare(1.2E3,13.8E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(23.8E3,[2000 4000], [-0.7E3 -17.5E3],'l','c');
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');

j=j+1;mySq{j}=MySquare(23E3,[0.5E3 2E3], [-100 400],'l','c');      % to x Hall right side to ellipse
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [23E3 -0.8E3],'r','b');
%}

%gmr 'VZ_SQ800x50umElH
%{

j=j+1;mySq{j}=MySquare(1.2E3,15E3, [0E3 17E3],'c','t'); % to y hall contact  low part
j=j+1;mySq{j}=MySquare(22.8E3,[4000 2000], [0.7E3 17.5E3],'r','c');  % to y hall long
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

%j=j+1;mySq{j}=MySquare(19.5E3,[5e3 1.2E3], [-3.5E3 0],'r','c');  % to x Hall left side
%j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
j=j+1;mySq{j}=MySquare(2E3,21E3, [-25E3 10.5E3],'l','t');
%
%
j=j+1;mySq{j}=MySquare(1.2E3,13.8E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(23.8E3,[2000 4000], [-0.7E3 -17.5E3],'l','c');
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');

j=j+1;mySq{j}=MySquare(23E3,[1E3 3E3], [100 0],'l','c');      % to x Hall right side to ellipse
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [23E3 -0.8E3],'r','b');
%}
%%%%%%%%%%%%%%%%%%
%hall 1 'VZ_HallX30x1' HallX30x1Con
%{
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 7E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(26E3,[5000 1000], [0.7E3 7.5E3],'r','c');  % to y hall long
j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

j=j+1;mySq{j}=MySquare(8.5E3,[1.8e3 1E3], [-14.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([5000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode

%
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -7E3],'c','b'); 
j=j+1;mySq{j}=MySquare(26E3,[1000 5000], [-0.7E3 -7.5E3],'l','c');
j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');
j=j+1;mySq{j}=MySquare(8.5E3,[1.2e3 1.8E3], [14.5E3 0],'l','c');
j=j+1;mySq{j}=MySquare([1000 5000],11.8E3, [23E3 -0.8E3],'r','b');
%}

%hall 1 'VZ_HallY30x2'  HallY30x2Con
%{
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 17E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(21.8E3,[4000 1000], [0.7E3 17.5E3],'r','c');  % to y hall long
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

j=j+1;mySq{j}=MySquare(18.5E3,[5e3 1.2E3], [-4.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
%
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-0.7E3 -17.5E3],'l','c');
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');

j=j+1;mySq{j}=MySquare(18.5E3,[1.2e3 5E3], [4.5E3 0],'l','c');
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [23E3 -0.8E3],'r','b');
%}
%hall 1 VZ_HallCross2um
%{
j=j+1;mySq{j}=MySquare(2E3,2.8E3, [0E3 17E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(21.8E3,[4000 1000], [0.7E3 17.5E3],'r','c');  % to y hall long
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [-20E3 9.5E3],'r','b'); % to  electrode

j=j+1;mySq{j}=MySquare(8.5E3,[5e3 2E3], [-14.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
%
j=j+1;mySq{j}=MySquare(2E3,2.8E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-0.7E3 -17.5E3],'l','c');
%j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');

j=j+1;mySq{j}=MySquare(8.5E3,[2e3 5E3], [14.5E3 0],'l','c');
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [23E3 -0.8E3],'r','b');
UnionMultiObjects=true;
%}
%non local hall 1 'VZ_HallX30x1'   HallX30x1Loc
%{


j=j+1;mySq{j}=MySquare([4E3 2E3],6.5E3, [-20E3 -4E3],'r','t'); % to  electrode
j=j+1;mySq{j}=MySquare(21.3E3,[2000 400], [-1.7E3 -3.5E3],'r','c');  % to y hall long

j=j+1;mySq{j}=MySquare(1E3,2.6E3, [-1700 -1000],'r','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(1E3,1E3, [-700 -700],'r','t'); % 
j=j+1;mySq{j}=MySquare(2.2E3,100, [500 -600],'r','t'); % to y hall contact parralel

j=j+1;mySq{j}=MySquare(8.5E3,[1.8e3 1E3], [-14.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([1000 4000],11.8E3, [-23E3 -0.8E3],'l','b'); %to electrode

%
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -7E3],'c','b'); 
j=j+1;mySq{j}=MySquare(26.6E3,[1000 5000], [-0.6E3 -7.5E3],'l','c');
j=j+1;mySq{j}=MySquare(6E3,1.5E3, [20E3 -9.5E3],'l','t');
j=j+1;mySq{j}=MySquare(8.5E3,[1.2e3 1.8E3], [14.5E3 0],'l','c');
j=j+1;mySq{j}=MySquare([1000 5000],11.8E3, [23E3 -0.8E3],'r','b');
%}

%non local hall 1 'VZ_HallY400x30um'   HallY400x30Loc
%{
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 17E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 17.5E3],'l','c');  % to y hall long

j=j+1;mySq{j}=MySquare(18.5E3,[5e3 1.2E3], [-4.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
%
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -17E3],'c','b'); 
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 -17.5E3],'l','c');

% non-local contact
j=j+1;mySq{j}=MySquare(3E3,1.4E3, [-23.6E3 9.6E3],'l','b'); % near electrode
j=j+1;mySq{j}=MySquare(21E3,[3000 1000], [-2600 7000],'r','b'); % to y hall contact long
j=j+1;mySq{j}=MySquare(1E3,5.3E3, [-3600 2700],'l','b'); % to y hall contact
j=j+1;mySq{j}=MySquare(2.6E3,1E3, [-1000 1700],'r','b'); % to y hall contact
j=j+1;mySq{j}=MySquare(1.25E3,1E3, [-450 700],'r','b'); % 
j=j+1;mySq{j}=MySquare(100,2.2E3, [-350 -500],'r','b'); % to y hall contact parralel
%}

%up non local hall 1 'VZ_HallY400x30um'   HallY400x30LUp
%{
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 17E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 17.5E3],'l','c');  % to y hall long

j=j+1;mySq{j}=MySquare(18.5E3,[5e3 1.2E3], [-4.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
j=j+1;mySq{j}=MySquare(18.5E3,[1.2e3 5E3], [4.5E3 0],'l','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [24.5E3 0.8E3],'r','t'); %to electrode
%
%j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -17E3],'c','b'); 
%j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 -17.5E3],'l','c');

% non-local contact
j=j+1;mySq{j}=MySquare(3E3,1.4E3, [-23.6E3 9.6E3],'l','b'); % near electrode
j=j+1;mySq{j}=MySquare(21E3,[3000 1000], [-2600 7000],'r','b'); % to y hall contact long
j=j+1;mySq{j}=MySquare(1E3,5.3E3, [-3600 2700],'l','b'); % to y hall contact
j=j+1;mySq{j}=MySquare(2E3,1E3, [-1600 1700],'r','b'); % to y hall contact
j=j+1;mySq{j}=MySquare(2.8E3,1E3, [-250 700],'r','b'); % 
j=j+1;mySq{j}=MySquare(300,700, [-150 300],'r','b'); % 
j=j+1;mySq{j}=MySquare(300,700, [0 150],'c','b'); % 
%j=j+1;mySq{j}=MySquare(100,2.2E3, [-1050 -500],'r','b'); % to y hall contact parralel


%}

%up non local hall 1 'VZ_HallY2x30um'  HallY30x2LUp
%{
j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 17E3],'c','t'); % to y hall contact
j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 17.5E3],'l','c');  % to y hall long

j=j+1;mySq{j}=MySquare(18.5E3,[5e3 1.2E3], [-4.5E3 0],'r','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [-25E3 0.8E3],'l','t'); %to electrode
%
j=j+1;mySq{j}=MySquare(18.5E3,[1.2e3 5E3], [4.5E3 0],'l','c');  % to x Hall
j=j+1;mySq{j}=MySquare([4000 1000],11.8E3, [24.5E3 0.8E3],'r','t'); %to electrode
%
%j=j+1;mySq{j}=MySquare(1.2E3,2.8E3, [0E3 -17E3],'c','b'); 
%j=j+1;mySq{j}=MySquare(21.8E3,[1000 4000], [-600 -17.5E3],'l','c');

% non-local contact
j=j+1;mySq{j}=MySquare(3E3,1.4E3, [-23.6E3 9.6E3],'l','b'); % near electrode
j=j+1;mySq{j}=MySquare(21E3,[3000 1000], [-2600 7000],'r','b'); % to y hall contact long
j=j+1;mySq{j}=MySquare(1E3,6.9E3, [-3600 2000],'l','b'); % to y hall contact
%j=j+1;mySq{j}=MySquare(2E3,1E3, [-1600 1700],'r','b'); % to y hall contact
%j=j+1;mySq{j}=MySquare(2.8E3,1E3, [-250 1700],'r','b'); % 
j=j+1;mySq{j}=MySquare(3000,700, [-150 2000],'r','b'); % 
j=j+1;mySq{j}=MySquare(300,700, [0 1800],'c','b'); % 
%j=j+1;mySq{j}=MySquare(100,2.2E3, [-1050 -500],'r','b'); % to y hall contact parralel


%}



%doubleElectrode  DoubleElctrode1
%{

j=j+1;mySq{j}=MySquare(1E3 ,1.8E3, [0 23.8E3],'c','b'); % 
j=j+1;mySq{j}=MySquare(24E3,[3E3 1E3], [0.5E3 25.5E3],'r','c'); % 


j=j+1;mySq{j}=MySquare(2E3 ,16E3, [-22E3 -5E3],'c','c'); % 
j=j+1;mySq{j}=MySquare(25E3,[3E3 1E3], [2E3 3E3],'r','c'); % 


j=j+1;mySq{j}=MySquare(1E3 ,1.8E3, [0 -23.8E3],'c','t'); % 
j=j+1;mySq{j}=MySquare(24E3,[1E3 3E3], [-0.5E3 -25.5E3],'l','c'); % 


j=j+1;mySq{j}=MySquare(2E3 ,16E3, [22E3 5E3],'c','c'); % 
j=j+1;mySq{j}=MySquare(25E3,[1E3 3E3], [-2E3 -3E3],'l','c'); % 



%}

%% main code

if Plot4Electrodes
    jBack=0;
    tmp=MySquare(6E3,26E3, [-20E3 10E3],'r','b');
    tmp1=MySquare(30E3,10E3, [-26E3 36E3],'r','t');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    tmp=MySquare(12E3,18E3, [-44E3 36E3],'r','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    tmp=MySquare(30E3,10E3, [-26E3 54E3],'r','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    jBack=jBack+1;MyPlotBackground{jBack}=tmp1;clear tmp1;

    tmp1=MySquare(6E3,26E3, [20E3 10E3],'l','b');
    tmp=MySquare(30E3,10E3, [26E3 36E3],'l','t');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    tmp=MySquare(12E3,18E3, [44E3 36E3],'l','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    tmp=MySquare(30E3,10E3, [26E3 54E3],'l','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    jBack=jBack+1;MyPlotBackground{jBack}=tmp1;clear tmp1;

    tmp=MySquare(6E3,36E3, [-20E3 -10E3],'r','t');
    tmp1=MySquare(30E3,20E3, [-26E3 -46E3],'r','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    jBack=jBack+1;MyPlotBackground{jBack}=tmp1;clear tmp1;

    tmp=MySquare(6E3,36E3, [20E3 -10E3],'l','t');
    tmp1=MySquare(30E3,20E3, [26E3 -46E3],'l','b');
    [xc,yc] = polybool('union',tmp(:,1),tmp(:,2),tmp1(:,1),tmp1(:,2));clear tmp;clear tmp1; tmp1=[xc yc];
    jBack=jBack+1;MyPlotBackground{jBack}=tmp1;clear tmp1;
    %exist('MyPlotBackground','var');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%plot before union
if UnionMultiObjects
figure(21)
for j1=1:j
     plot(mySq{j1}(:,1),mySq{j1}(:,2));
     if j1==1
         hold on;
     end
end
hold off

%%%%%%%%%%%%%%%%%%%%%%%%%%
id='map:polygon:noExternalContours';
warning('off',id);

ObjectsNum=1;
MultiObject{1}=mySq{1};

for j1=2:j
    newObject=true;
      for jOb=1:ObjectsNum
    clear a;a=MultiObject{jOb};
    clear b; b=mySq{j1};
AinB= inpolygon(a(:,1),a(:,2),b(:,1),b(:,2)); % poly A in poly B
%BinA= inpolygon(b(:,1),b(:,2),a(:,1),a(:,2)); % poly B in poly A

if sum(AinB)
    %disp('overcross')
    [xc,yc] = polybool('union',a(:,1),a(:,2),b(:,1),b(:,2)); % 'union',
    MultiObject{jOb}=[xc yc];
    newObject=false;
    break %jOb
else
    %disp('no');
    c=a;
end

      end %jOb

    if newObject
        ObjectsNum=ObjectsNum+1;
        MultiObject{ObjectsNum}=mySq{j1};
    end
end

disp([' number of objects' num2str(ObjectsNum)']);

% plot all objects before inline
%{
figure (11);
for j1=1:ObjectsNum
     plot(MultiObject{j1}(:,1),MultiObject{j1}(:,2));
     if j1==1
         hold on;
     end
end
hold off
%}

%%%% inline

jAll=0;
for j1=1:ObjectsNum
    if UseNewInLine
     [MyMain, MyLine]= newInLine(MultiObject{j1},InLineWidth,InLineGapWidth)  ;
     myDigital=5; % number of used digitals
     MyMain=SimplifyLines(MyMain,myDigital);
    MyLine=SimplifyLines(MyLine,myDigital);
     
     
    else
        %[MultiObject{j1}(:,1), MultiObject{j1}(:,2)] = poly2cw(MultiObject{j1}(:,1), MultiObject{j1}(:,2));
        [MyLine, MyAreaTmp]=InLineObject(MultiObject{j1}(1:length(MultiObject{j1}(:,1))-1,:),InLineWidth);
        [tmp1, MyMain]=InLineObject(MyAreaTmp,InLineGapWidth);
    end
    jAll=jAll+1;
    AllObjects(jAll).MyObj=MyMain*k;
    AllObjects(jAll).MyRank=1;
        jAll=jAll+1;
    AllObjects(jAll).MyObj=MyLine*k;
    AllObjects(jAll).MyRank=2;
    clear MyMain; clear MyLine;
end
  
    
% plot all objects inlined
%{       
figure (12);
for j1=1:length(AllObjects)
     plot(AllObjects(j1).MyObj(:,1),AllObjects(j1).MyObj(:,2));
     if j1==1
         hold on;
     end
end
hold off
%}

MakeSingleObjectInLine=false;
end
%}

%% end

%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%  simple Hall bar
%{
MainLineWidth=0.4*1000;  %um
MainLineLength=30*1000;  %um

SideLineWidth=0.4*1000; %um
SideLineLength= 10*1000; %um

MainLineAlongX=false;



%%%
if MainLineAlongX
Lx=MainLineLength/2; dLy=MainLineWidth/2;
Ly=SideLineLength/2; dLx=SideLineWidth/2;
else
Ly=MainLineLength/2; dLx=MainLineWidth/2;
Lx=SideLineLength/2; dLy=SideLineWidth/2;    
end   


MyObject=[-Lx -dLy; -dLx -dLy; -dLx -Ly; dLx -Ly; dLx -dLy; Lx -dLy; Lx dLy; dLx dLy; dLx Ly; -dLx Ly; -dLx dLy; -Lx dLy];


%MyObject=flipud(MyObject1);

%}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%  resistance bar
%{
MainLineWidth=0.4*1000;  %um
MainLineLength=30*1000;  %um

SideLineWidth=0.4*1000; %um
SideLineLength= 10*1000; %um

MainLineAlongX=false;

DistanceBetweenElectrodes=15E3;

%%%
DW=DistanceBetweenElectrodes/2;
if MainLineAlongX
Lx=MainLineLength/2; dLy=MainLineWidth/2;
Ly=SideLineLength/2; dLx=SideLineWidth/2;
MyObject=[-Lx -dLy; -dLx+DW -dLy; -dLx+DW -Ly; dLx+DW -Ly; dLx+DW -dLy; Lx -dLy; Lx dLy; dLx-DW dLy; dLx-DW Ly; -dLx-DW Ly; -dLx-DW dLy; -Lx dLy];
else
Ly=MainLineLength/2; dLx=MainLineWidth/2;
Lx=SideLineLength/2; dLy=SideLineWidth/2;
MyObject=[-Lx -dLy+DW; -dLx -dLy+DW; -dLx -Ly; dLx -Ly; dLx -dLy-DW; Lx -dLy-DW; Lx dLy-DW; dLx dLy-DW; dLx Ly; -dLx Ly; -dLx dLy+DW; -Lx dLy+DW];
end   




MakeSingleObjectInLine=true;
%MyObject=flipud(MyObject1);

%}


%%%%%%%%%%%%  devided y-Hall bar
%{
MainLineWidth=2000*k;  %um  0.4 2
MainLineLength=30*1000*k;  %um

SideLineWidth= 1000*k; %um 0.4  1
SideLineLength= 10*1000*k; %um

LineWidth=70*k;  % nm
BetweenGap=100*k; %nm

%%%%%%%%%%%%%%%%%%%%%%%%%%%
SqX=SideLineLength/2;
SqY=LineWidth/2;
SquareBig=[-SqX SqY;-SqX -SqY; SqX -SqY; SqX SqY ];

   [MyLine1, MyAreaTmp]=InLineObject(SquareBig,InLineWidth);
    [tmp1, MyAreaR]=InLineObject(MyAreaTmp,InLineGapWidth);
    SquareBigObjects(1).MyObj=MyAreaR;
    SquareBigObjects(1).MyRank=1;
    SquareBigObjects(2).MyObj=MyLine1;
    SquareBigObjects(2).MyRank=2;

SqX=MainLineWidth/2;
SqY=LineWidth/2;
SquareSmall=[-SqX SqY;-SqX -SqY; SqX -SqY; SqX SqY ];

   [MyLine1, MyAreaTmp]=InLineObject(SquareSmall,InLineWidth);
    [tmp1, MyAreaR]=InLineObject(MyAreaTmp,InLineGapWidth);
    SquareSmallObjects(1).MyObj=MyAreaR;
    SquareSmallObjects(1).MyRank=1;
    SquareSmallObjects(2).MyObj=MyLine1;
    SquareSmallObjects(2).MyRank=2;
    
    
%%%
% %
% center
j1=1;
AllObjects(j1)=SquareBigObjects(1); j1=j1+1;
AllObjects(j1)=SquareBigObjects(2); j1=j1+1;

% up
myY=LineWidth/2+BetweenGap;
myShift=0;

for j2=(LineWidth/2+BetweenGap):(LineWidth+BetweenGap):(SideLineWidth/2)
    myShift=myShift+LineWidth+BetweenGap;
    AllObjects(j1)=SquareBigObjects(1);AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift; j1=j1+1;
    AllObjects(j1)=SquareBigObjects(2);AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift; j1=j1+1;
    myY=myY+LineWidth+BetweenGap;
end
    for j2=myY:(LineWidth+BetweenGap):(MainLineLength/2)
    myShift=myShift+LineWidth+BetweenGap;
    AllObjects(j1)=SquareSmallObjects(1); AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift;j1=j1+1;
    AllObjects(j1)=SquareSmallObjects(2);AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift; j1=j1+1;
    end
% {
    myY=-(LineWidth/2+BetweenGap);
    myShift=0;
for j2=-(LineWidth/2+BetweenGap):-(LineWidth+BetweenGap):-(SideLineWidth/2)
    myShift=myShift-(LineWidth+BetweenGap);
    AllObjects(j1)=SquareBigObjects(1); AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift;j1=j1+1;
    AllObjects(j1)=SquareBigObjects(2); AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift;j1=j1+1;
    myY=myY-(LineWidth+BetweenGap);
end
    
    for j2=myY:-(LineWidth+BetweenGap):-(MainLineLength/2)
    myShift=myShift-(LineWidth+BetweenGap);
    AllObjects(j1)=SquareSmallObjects(1);AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift; j1=j1+1;
    AllObjects(j1)=SquareSmallObjects(2);AllObjects(j1).MyObj(:,2)=AllObjects(j1).MyObj(:,2)+myShift; j1=j1+1;
    end



Plot4Electrodes=false;
UnionMultiObjects=false; 
UseNewInLine=false;
MakeSingleObjectInLine=false;
%}
    
  
  



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%  code processing

%%%%%%%%%%%%%%%%% inline single object
if MakeSingleObjectInLine
   [MyLine1, MyAreaTmp]=InLineObject(MyObject,InLineWidth);
    [tmp1, MyAreaR]=InLineObject(MyAreaTmp,InLineGapWidth);
    AllObjects(1).MyObj=MyAreaR*k;
    AllObjects(1).MyRank=1;
    AllObjects(2).MyObj=MyLine1*k;
    AllObjects(2).MyRank=2;

end


MyCenterPosition(1)=0;MyCenterPosition(2)=0;
rawPlotting=false;  % this will plot without resizing
StandartProcessing
clear AllObjects1;